//
//  MCQueryCriteriaBrowserView.h
//  MCApplication
//
//  Created by Michael Clark on 01/09/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCBrowserController;
@class BDQualifier;
@class MCPDocument;


@interface MCQueryCriteriaBrowserView : NSView {
	IBOutlet NSBrowser*                  browser;
	IBOutlet MCBrowserController*   browserController;
	IBOutlet NSButton*                   moreOptionsSwitch;
	
	NSDictionary*              config;
	NSArray*                   _criterias;

	BDQualifier*               _basicModeQualifier;
	
	MCPDocument*   __document;
	
	id             __dataSource;
}

- (IBAction)toggleMode: (id)sender;

- (NSBrowser*)browser;

- (void)setTitle: (NSString*)aTitle;

- (NSString *)criteriaSubsetIdentifier;
- (NSString*)entityName;
- (NSDictionary*)qualifierConfig;

- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (id)dataSource;
- (void)setDataSource:(id)aDataSource;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)aDocument;
@end


@interface NSObject (MCQueryCriteriaBrowserViewDataSource)

- (NSArray*)queryCriteriaBrowserView: (MCQueryCriteriaBrowserView*)view queryCriteriasForEntityNamed: (NSString*)entityName criteriaSubsetIdentifier:(NSString *)configIdent;

@end
